/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CWindow.h,v 1.7 2000/02/01 01:37:51 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CWindow_h	// [
#define Included_CWindow_h

#include "pgpClassesConfig.h"
#include "CList.h"

#include "CMessage.h"
#include "CPoint.h"

#include "CHashTable.h"
#include "CRMWOLock.h"

_PGP_BEGIN

// Types

class CDC;
class CRect;
class CString;


// Class CWindow

class CWindow : public CListableObject<CWindow>
{
	NOT_COPYABLE(CWindow)

private:
	enum {WindowMapSize = 100};

public:
	CWindow();
	CWindow(HWND hWnd);
	virtual ~CWindow();

	CWindow&	operator=(HWND hWnd);

	operator HWND() const {return mHwnd;}
	HWND	Handle() const {return mHwnd;}

	PGPBoolean	WeCreated() const {return mWeCreated;}
	PGPBoolean	WeSubclassed() const {return mWeSubclassed;}

	void		Center() const;

	PGPBoolean	ClientToScreen(POINT& point) const
	{
		return ::ClientToScreen(Handle(), &point);
	}

	PGPBoolean	ClientToScreen(CRect& rect);

	PGPBoolean	DestroyWindow() const
	{
		return ::DestroyWindow(Handle());
	}

	PGPBoolean	DrawMenuBar() const
	{
		return ::DrawMenuBar(Handle());
	}

	PGPBoolean	EnableWindow(PGPBoolean enable) const
	{
		return ::EnableWindow(Handle(), enable);
	}

	PGPBoolean	FitFormattedTextToWindow(const char *formatString, 
		const char *subString) const;

	PGPBoolean	FitTextToWindow(const char *cstr) const;

	PGPBoolean	GetClientRect(RECT& rect) const;

	static HWND	GetDesktopWindow()
	{
		return ::GetDesktopWindow();
	}

	PGPInt32	GetDlgCtrlID() const
	{
		return ::GetDlgCtrlID(Handle());
	}

	HWND	GetDlgItem(PGPInt32 itemId) const
	{
		return ::GetDlgItem(Handle(), itemId);
	}

	static HWND	GetFocus()
	{
		return ::GetFocus();
	}

	HFONT		GetFont() const
	{
		return reinterpret_cast<HFONT>(SendMessage(WM_GETFONT));
	}

	HWND		GetLastActivePopup() const
	{
		return ::GetLastActivePopup(Handle());
	}

	HWND		GetParent() const
	{
		return ::GetParent(Handle());
	}

	PGPUInt32	GetStyle() const
	{
		return GetWindowLong(GWL_STYLE);
	}

	HWND		GetWindow(PGPUInt32 uCmd) const
	{
		return ::GetWindow(Handle(), uCmd);
	}

	LONG		GetWindowLong(PGPInt32 index) const
	{
		return ::GetWindowLong(Handle(), index);
	}

	PGPBoolean	GetWindowRect(RECT& rect) const;
	PGPBoolean	GetWindowText(CString& text) const;

	PGPBoolean	InvalidateRect(const RECT *pRect = NULL, 
		PGPBoolean erase = TRUE)
	{
		return ::InvalidateRect(Handle(), pRect, erase);
	}

	PGPBoolean	IsWindowVisible() const
	{
		return ::IsWindowVisible(Handle());
	}

	PGPBoolean	IsWindow() const
	{
		return ::IsWindow(Handle());
	}

	static PGPBoolean	IsWindow(HWND hWnd)
	{
		return ::IsWindow(hWnd);
	}

	PGPBoolean	IsWindowEnabled() const
	{
		return ::IsWindowEnabled(Handle());
	}

	PGPInt32	MapWindowPoints(HWND hwndTo, LPPOINT points, 
		PGPUInt32 numPoints) const;

	PGPBoolean	MoveWindow(PGPInt32 X, PGPInt32 Y, PGPInt32 width, 
		PGPInt32 height, PGPBoolean repaint = TRUE) const;

	LRESULT		PostMessage(UINT uMsg, WPARAM wParam = 0, 
		LPARAM lParam = 0) const
	{
		return ::PostMessage(Handle(), uMsg, wParam, lParam);
	}

	LRESULT		PostMessage(CMessage msg) const
	{
		return ::PostMessage(Handle(), msg.Message(), msg.WParam(), 
			msg.LParam());
	}

	PGPBoolean	RedrawWindow(const RECT *pRect, HRGN region, PGPUInt32 flags)
	{
		return ::RedrawWindow(Handle(), pRect, region, flags);
	}

	static PGPBoolean	ReleaseCapture()
	{
		return ::ReleaseCapture();
	}

	PGPBoolean	ScreenToClient(CPoint& point)
	{
		return ::ScreenToClient(Handle(), point);
	}

	PGPBoolean	ScreenToClient(CRect& rect);

	HWND		SetCapture() const
	{
		return ::SetCapture(Handle());
	}

	HWND		SetActiveWindow() const
	{
		return ::SetActiveWindow(Handle());
	}

	LRESULT		SendMessage(UINT uMsg, WPARAM wParam = 0, 
		LPARAM lParam = 0) const
	{
		return ::SendMessage(Handle(), uMsg, wParam, lParam);
	}

	LRESULT		SendMessage(CMessage msg) const
	{
		return ::SendMessage(Handle(), msg.Message(), msg.WParam(), 
			msg.LParam());
	}
	
	LRESULT		SendMessageTimeout(UINT uMsg, WPARAM wParam, LPARAM lParam, 
		PGPUInt32 flags, PGPUInt32 ms, DWORD& result) const
	{
		return ::SendMessageTimeout(Handle(), uMsg, wParam, lParam, flags, 
			ms, &result);
	}
	
	PGPBoolean	SetForegroundWindow() const
	{
		return ::SetForegroundWindow(Handle());
	}

	void		SetFocus() const
	{
		::SetFocus(Handle());
	}

	void		SetFont(HFONT font, PGPBoolean redraw = FALSE) const
	{
		SendMessage(WM_SETFONT, reinterpret_cast<WPARAM>(font), redraw);
	}

	HWND		SetParent(HWND newParent) const
	{
		return ::SetParent(Handle(), newParent);
	}

	PGPUInt32	SetStyle(PGPUInt32 newStyle) const
	{
		return SetWindowLong(GWL_STYLE, newStyle);
	}

	LONG		SetWindowLong(PGPInt32 index, LONG newLong) const
	{
		return ::SetWindowLong(Handle(), index, newLong);
	}

	PGPBoolean	SetWindowText(const char *text) const;

	PGPBoolean	SetWindowPos(HWND hWndInsertAfter, PGPInt32 X, PGPInt32 Y, 
		PGPInt32 cx, PGPInt32 cy, PGPUInt32 uFlags) const;

	PGPBoolean	ShowScrollBar(PGPInt32 wBar, PGPBoolean show) const
	{
		return ::ShowScrollBar(Handle(), wBar, show);
	}

	PGPBoolean	ShowWindow(int state) const
	{
		return ::ShowWindow(Handle(), state);
	}

	PGPBoolean	UpdateWindow() const
	{
		return ::UpdateWindow(Handle());
	}

	static HWND	WindowFromPoint(POINT point)
	{
		return ::WindowFromPoint(point);
	}

	void	Attach(HWND hWnd);

	static PGPBoolean	GetClassInfo(const char *className, WNDCLASSEX& classEx);

	static ATOM	RegisterClass(const char *className, WNDCLASSEX& classEx);

	static ATOM	RegisterClass(const char *className, PGPUInt32 style = 0, 
		PGPInt32 clsExtra = 0, PGPInt32 wndExtra = 0, HICON icon = NULL, 
		HICON smallIcon = NULL, HCURSOR cursor = NULL, 
		HBRUSH background = NULL, const char *menuName = NULL);

	static void	UnregisterClass(const char *classNameOrAtom);

	void	Subclass(HWND hWnd);
	void	UnSubclass();

	void	ShowModal(HACCEL accel = NULL);

	void	Create(const char *classNameOrAtom, WNDPROC superedProc, 
		const char *windowName, PGPUInt32 style, PGPUInt32 exStyle, 
		PGPInt32 x = CW_USEDEFAULT, PGPInt32 y = 0, 
		PGPInt32 width = CW_USEDEFAULT, PGPInt32 height = 0, 
		HWND parent = NULL, HMENU menu = NULL);

	void	Close();

protected:
	virtual LRESULT	CallDefault();
	virtual void	HandleWindowError(CComboError error) { }

	const CMessage&	CurMsg() const {return mCurMsg;}

private:
	PGPBoolean	mWeCreated;
	PGPBoolean	mWeSubclassed;

	PGPBoolean	mInModal;
	PGPBoolean	mSawClose;

	CMessage	mCurMsg;
	HWND		mHwnd;
	WNDPROC		mPrevWndProc;

	static CHashTable<CWindow>	*mWindowMap;
	static CRMWOLock			*mWindowMapLock;
	static PGPUInt32			mWindowMapRefCount;

	// Window map functions.

	static void			RefWindowMap();
	static void			DerefWindowMap();

	static CWindow *	HandleToWindow(HWND hWnd);
	static void			AssocHandleToWindow(HWND hWnd, CWindow *pWindow);
	static void			UnAssocHandleFromWindow(HWND hWnd);

	// Windows procedure functions.

	PGPBoolean			DispatchCommon(LRESULT& result);

	virtual PGPBoolean	PreProcess(const CMessage& msg, LRESULT& result)
	{
		return FALSE;
	}

	virtual void		PostProcess(const CMessage& msg, LRESULT result)
	{
	}

	LRESULT	WindowProc(const CMessage& msg);

	static LRESULT CALLBACK	GlobalWindowProc(HWND hWnd, UINT uMsg, 
		WPARAM wParam, LPARAM lParam);

	static LRESULT CALLBACK	GlobalWindowProcSubclassed(HWND hWnd, UINT uMsg, 
		WPARAM wParam, LPARAM lParam);

protected:
	// Windows message handlers.
	virtual BOOL	OnCommand(PGPUInt16 notifyCode, PGPUInt16 itemId, 
		HWND ctrl);

	virtual void	OnContextMenu(HWND menuWnd, CPoint coords)
	{
		CallDefault();
	}

	virtual void	OnChar(char c, PGPUInt32 keyData)
	{
		CallDefault();
	}

	virtual void	OnClear() 
	{
		CallDefault();
	}
	
	virtual void	OnClose();

	virtual void	OnCopy() 
	{
		CallDefault();
	}

	virtual PGPInt32	OnCreate(LPCREATESTRUCT pCS) 
	{
		return CallDefault();
	}

	virtual HBRUSH	OnCtlColorStatic(HDC ctlDC, HWND ctlHwnd) 
	{
		return reinterpret_cast<HBRUSH>(CallDefault());
	}

	virtual void	OnCut() 
	{
		CallDefault();
	}

	virtual BOOL	OnDrawItem(PGPUInt16 ctrlId, LPDRAWITEMSTRUCT pDIS);

	virtual BOOL	OnEraseBkgnd(HDC dc)
	{
		return CallDefault();
	}

	virtual void	OnDestroy() 
	{
		CallDefault();
	}

	virtual void	OnGetMinMaxInfo(LPMINMAXINFO pMMI)
	{
		CallDefault();
	}

	virtual void	OnHelp(HELPINFO	*pInfo)
	{
		CallDefault();
	}

	virtual void	OnInitMenu(HMENU menu)
	{
		CallDefault();
	}

	virtual void	OnKeyDown(PGPUInt32 vKey, PGPUInt32 keyData) 
	{
		CallDefault();
	}

	virtual void	OnKeyUp(PGPUInt32 vKey, PGPUInt32 keyData) 
	{
		CallDefault();
	}

	virtual void	OnKillFocus()
	{
		CallDefault();
	}

	virtual void	OnLButtonDblClk(PGPUInt32 keyFlags, CPoint coords) 
	{
		CallDefault();
	}
	
	virtual void	OnLButtonDown(PGPUInt32 keyFlags, CPoint coords) 
	{
		CallDefault();
	}

	virtual void	OnLButtonUp(PGPUInt32 keyFlags, CPoint coords) 
	{
		CallDefault();
	}

	virtual BOOL	OnMeasureItem(PGPUInt16 ctrlId, LPMEASUREITEMSTRUCT pMIS);

	virtual void	OnMenuSelect(PGPUInt16 ctrlId, PGPUInt16 flags, 
		HMENU hwndMenu)
	{
		CallDefault();
	}

	virtual void	OnMouseMove(PGPUInt32 keyFlags, CPoint coords) 
	{
		CallDefault();
	}

	virtual BOOL	OnNcCreate(LPCREATESTRUCT pCS) 
	{
		return CallDefault();
	}

	virtual void	OnNcDestroy() 
	{
		CallDefault();
	}

	virtual PGPUInt32	OnNotify(PGPUInt16 ctrlId, LPNMHDR pNMHDR);

	virtual void	OnPaint(HDC paintDC) 
	{
		CallDefault();
	}

	virtual void	OnPaste() 
	{
		CallDefault();
	}

	virtual void	OnSetFocus()
	{
		CallDefault();
	}
	
	virtual void	OnSize(PGPUInt16 flags, PGPUInt16 width, 
		PGPUInt16 height) 
	{
		CallDefault();
	}

	virtual void	OnSysColorChange()
	{
		CallDefault();
	}
	
	virtual BOOL	OnSysCommand(PGPUInt16 cmdType, PGPInt16 xPos, 
		PGPInt16 yPos)
	{
		return CallDefault();
	}
	
	virtual void	OnTimer(PGPUInt32 timerID, TIMERPROC *timerProc)
	{
		CallDefault();
	}

	virtual BOOL	OnUndo() 
	{
		CallDefault();
		return FALSE;
	}
};

_PGP_END

#endif	// ] Included_CWindow_h
